/*****************************************************************************/
/* dllist.h - header file                                                    */
/* Implementation of a singlely linked list ADT.                             */
/* Created: 10/21/1999 by Robert Schutt                                      */
/* Problems: email rschutt@cs.virginia.edu                                   */
/*****************************************************************************/
#ifndef _DLLIST_ADT
#define _DLLIST_ADT

typedef struct _dll_node {
    void *data; /* data for the linked list */
    struct _dll_node *next; /* pointer to the next dll_node */
    struct _dll_node *prev; /* pointer to the next dll_node */
} dll_node;

/*****************************************************************************/
/* void dll_init (dll_node **head);                                          */
/* Initializes the linked list.                                              */
/* Parameters:                                                               */
/*     head: the pointer to the head of the list.                            */
/*****************************************************************************/

void dll_init (dll_node **head, dll_node **tail);


/*****************************************************************************/
/* int dll_movenext (dll_node **lptr);                                       */
/* Move to the next entry in the list.                                       */
/* Returns 1 if successful and 0 otherwise.                                  */
/* Parameters:                                                               */
/*     lptr: current pointer in the list.                                    */
/*****************************************************************************/

void dll_movenext (dll_node **lptr);

/*****************************************************************************/
/* void dll_insert (dll_node *lptr, void *newdata);                          */
/* Inserts data at the current position.                                     */
/* Parameters:                                                               */
/*     lptr: current pointer in the list.                                    */
/*     newdata: a void pointer to the new data.                              */
/*****************************************************************************/

void dll_insert (dll_node **head, dll_node **tail, dll_node **lptr, void *newdata);


/*****************************************************************************/
/* void dll_insert_front (dll_node **head, void *newdata);                   */
/* Inserts data at the head of the list.                                     */
/* Parameters:                                                               */
/*     lptr: current pointer in the list.                                    */
/*     newdata: a void pointer to the new data.                              */
/*****************************************************************************/

void dll_insert_front (dll_node **head, dll_node **tail, void *newdata);

/*****************************************************************************/
/* void* dll_getdata (dll_node *lptr);                                       */
/* Gets the data stored in the current dll_node.                             */
/* Parameters:                                                               */
/*     lptr: current pointer in the list.                                    */
/* Returns: pointer to the data at the current dll_node.                     */
/*****************************************************************************/

void* dll_getdata (dll_node *lptr);


/*****************************************************************************/
/* int dll_delete (dll_node **lptr);                                         */
/* Deletes the current dll_node from the linked list.                        */
/* Parameters:                                                               */
/*     lptr: current pointer in the list.                                    */
/* Returns: 1 if successful 0 otherwise.                                     */
/*****************************************************************************/

int dll_delete (dll_node **head, dll_node **tail, dll_node **lptr);

/*****************************************************************************/
/* int dll_empty (dll_node *head);                                           */
/* Tests if the list is empty.                                               */
/* Parameters:                                                               */
/*     head: head of the list.                                               */
/* Returns: 1 if empty, 0 otherwise.                                         */
/*****************************************************************************/

int dll_empty (dll_node *head);

/*****************************************************************************/
/* int dll_end (dll_node *lptr);                                             */
/* Tests if the list is at the end.                                          */
/* Parameters:                                                               */
/*     lptr: current pointer in the list.                                    */
/* Returns: 1 if at the end, 0 otherwise.                                    */
/*****************************************************************************/

int dll_end (dll_node *lptr);

/*****************************************************************************/
/* int dll_onlist (dll_node *lptr);                                          */
/* Returns true if lptr is on the list.                                      */
/*****************************************************************************/

int dll_onlist (dll_node *lptr);

void dll_insert_rear (dll_node **head, dll_node **tail, void *newdata);
void dll_movehead (dll_node *head, dll_node **ptr);
void dll_movetail (dll_node *head, dll_node **ptr);
void dll_moveprev (dll_node **lptr);
#endif

/*********************************** sslist.h ********************************/

