
//****************************************************************************/
//* ms_gmq.h - header file                                                   */
//* Global message queue data structure.                                     */
//****************************************************************************/

#ifndef _ms_gmq
#define _ms_gmq

#include "ms_mbox.h"

class MS_Gmq {
	
	MS_Mbox *mbox; //* array of message boxes */

public:
	
	//* initializes the message box */
	
	void init (int numnodes);
		
	//* public functions that should be used in client code. */

	int send (int from_addr, int to_addr, void *buf, int len);


	int recv (int recv_addr, int from_addr, void *buf, int len);


	int recv_any (int recv_addr, void *buf, int len, int *sender);

	/* returns the length of the message in the queue, will block if there are no messages in the queue */

	int len (int recv_addr);

};

#endif

//********************************* ms_gmq.cpp *******************************/

