
//****************************************************************************/
//* ms_mbox.h - header file                                                  */
//* Message box definition.                                                  */
//****************************************************************************/

#ifndef _ms_mbox
#define _ms_mbox

#include "dllist.h"
#include <process.h>
#include <windows.h>

class MS_Mbox {

//* class variables */


	dll_node *head, *tail;

	CRITICAL_SECTION csec;
	HANDLE sem;

//* private functions that should not be used in client code */

public:

	MS_Mbox ();


	//* initializes the message box */

	void init ();

	void insert (int sender, void *buf, int len);

//* public functions that should be used in client code. */


//****************************************************************************/
//* int recv (int from_addr, char *buf, int len);                            */
//* Receives a message from a another mailbox.  If there are no messages     */
//* waiting, the call to recv blocks until a message arrives.                */
//* Arguments:                                                               */
//*     int from_addr : the address of the node to receive a message from.   */
//*     char *buf     : a pointer to the buffer to send.                     */
//*     int len       : the length of the buffer in bytes.                   */
//****************************************************************************/

	int recv (int from_addr, void *buf, int len);

//****************************************************************************/
//* int recv (int from_addr, char *buf, int len);                            */
//* Receives a message from a another mailbox.  If there are no messages     */
//* waiting, the call to recv blocks until a message arrives.                */
//* Arguments:                                                               */
//*     char *buf     : a pointer to the buffer to send.                     */
//*     int len       : the length of the buffer in bytes.                   */
//*     int *sender   : the address of the node that sent the message.       */
//****************************************************************************/

	int recv_any (void *buf, int len, int *sender);

	/* returns the length of the next pending message ... will block if there are no messages in the queue */

	int len ();

};

#endif

//********************************* ms_mbox.h ********************************/

