
//****************************************************************************/
//* ms_mbox.h - header file                                                  */
//* Message box definition.                                                  */
//****************************************************************************/

#ifndef _ms_msgbox
#define _ms_msgbox

#include "ms_gmq.h"
class MS_Msgbox {

	int nodenum;

	MS_Gmq *mq;

//* private functions that should not be used in client code */

public:

	
	void init (int mynodenum, MS_Gmq *gmq);

//* public functions that should be used in client code. */

//****************************************************************************/
//* int send (int to_addr, void *buf, int len);                              */
//* Sends a message to another message box.                                  */
//* Arguments:                                                               */
//*     int to_addr   : the address of the node to send a message to.        */
//*     char *buf     : a pointer to the buffer to send.                     */
//*     int len       : the length of the buffer in bytes.                   */
//****************************************************************************/

	int send (int to_addr, void *buf, int len);

//****************************************************************************/
//* int recv (int from_addr, char *buf, int len);                            */
//* Receives a message from a another mailbox.  If there are no messages     */
//* waiting, the call to recv blocks until a message arrives.                */
//* Arguments:                                                               */
//*     int from_addr : the address of the node to receive a message from.   */
//*     char *buf     : a pointer to the buffer to send.                     */
//*     int len       : the length of the buffer in bytes.                   */
//****************************************************************************/

	int recv (int from_addr, void *buf, int len);

//****************************************************************************/
//* int recv (int from_addr, char *buf, int len);                            */
//* Receives a message from a another mailbox.  If there are no messages     */
//* waiting, the call to recv blocks until a message arrives.                */
//* Arguments:                                                               */
//*     char *buf     : a pointer to the buffer to send.                     */
//*     int len       : the length of the buffer in bytes.                   */
//*     int *sender   : the address of the node that sent the message.       */
//****************************************************************************/

	int recv_any (void *buf, int len, int *sender);

//****************************************************************************/
//* int len ();                                                              */
//* Returns the length of the next message in the queue.                     */
//* Note: This will block if there are no messages in the queue              */
//****************************************************************************/

	int len ();

};

#endif

//********************************* ms_msg_box.h ******************************/

