#ifndef SN_MANAGER_H
#define SN_MANAGER_H

// Disable truncated identifier message
#pragma warning(disable:4786)

#include "sn_process.h"
#include <set>
#include <map>

using namespace std;

class SN_Manager
{
	private:
		// statistics
		int round;
		int num_messages_sent;
		int num_messages_received;
		int num_messages_dropped;

		// pointer to MS infrastructure
		MS_Msgbox *m;

		// For storing messages from one process to another. (It's a two-dimensional
		// map.)
		typedef pair <int, int> Link;
		map <Link, SN_Message> channels;

		static set<SN_Process *> processes;

		// Needed by Start_Sim_Process so that it can know how to start the manager
		// (static functions have no this pointer.)
		static SN_Manager* self_ptr;

		// The MS framework calls this to start the network and each process.
		static void Start_Sim_Process(int process_id,MS_Msgbox *in_m,void *data);

		// Start_Sim_Process calls this to start the network, after all the processes
		// have started
		void Run(MS_Msgbox *);

		// Helper functions
		void Start_Round();
		void Get_Messages();
		void Send_Messages();
		void End_Round();
		void End_Simulation();

		virtual void Drop_Messages();
public:
		SN_Manager(int);
		~SN_Manager();

		// So that the processes and manager in the MS infrastructure know the manager is always
		// index 0. (We'd really like to do "static const int M_P_ID = 0", but the 
		// dumb M$ compiler won't let us
		enum { MANAGER_PROCESS_ID = 0};

		// The user calls this to start running the simulation
		void Start_Sim();

		// Client code calls this to insert a process into the network.
		void Insert_Process(SN_Process* new_process);
};

#endif // SN_MANAGER_H