#ifndef SN_PROCESS_H
#define SN_PROCESS_H

// Disable truncated identifier message
#pragma warning(disable:4786)

#include "ms_node.h"
#include "sn_message.h"
#include <set>
#include <map>

using namespace std;

/*
This class implements a process. Users should inherit from this class, adding
their own state, and providing the virtual methods.
*/
class SN_Process
{
	friend class SN_Manager;
private:
	// A pointer to the MS framework. Set when Run is called
	MS_Msgbox *m;

	// Choose a start state
	virtual void Set_Start_State() = 0;

	// State transition function
	virtual void Transition(map <SN_Message *,int> inbound_msgs) = 0;

	// Generates and sends a message
	virtual void Generate_Messages() = 0;

	// Process::Send calls this when it's done sending each round.
	void Send_Finished();

	// A helper function used by the two Send functions
	void _Send_Message(SN_Message* outbound_msg,int to_process_id);

protected:
	// Each new process is given a unique id, which is initialized by the constructor.
	// IDs start at 1, and correspond to the indexes in the MS framework.
	int process_id;

	// Send a single message for 1 round. Used by derived classes
	void Send(SN_Message* outbound_msg,int to_process_id);

	// Send multiple messages for 1 round. Used by derived classes
	void Send(map<SN_Message *,int> *outgoing_messages);

public:
	SN_Process();

	// Called by the manager to start the process
	void Run(MS_Msgbox *in_m);
};

#endif // SN_PROCESS_H