<?php

// Management page for category order plugin

include_once('category-order-shared.php');

class category_order_management {

// --------------------------------------------------------------------

function setup_category_order_management_page() {
	if (function_exists('add_management_page'))
		add_management_page('Category Order', 'Category Order', 9,
			basename(__FILE__),
			array('category_order_management','manage_category_order'));
}

// --------------------------------------------------------------------

// Main implementation of the management page
function manage_category_order() {
	category_order_management::handle_action();

	print("		<div class='wrap'>\n");
	print("		<h2> Manage Category Order </h2>\n");

	print "<h3>Category Order and Indentation</h3>\n";

	print '<p>Use this interface to manage the order and spacing of categories.
	You can move categories and spacers up and down. You can change the
	indention of a category, but not a spacer.</p>';

	category_order_management::print_category_table();

	// Reset order button
	{
		print "<form name='ResetCategoryOrder' method='post' action='" .
			$page_uri. "&action=reset'>";
		print "<p class='submit'>";
		print "<input type='submit' name='Submit' " .
			"value='Reset the Order to Single Level, Alphabetical'></p></form>";
	}


	// --------------------------------------------------------------

	print "<h3>Category Order Options</h3>\n";

	// Causes a class redefined error
	//$page_uri = $_SERVER['PHP_SELF'] . "?page=" . plugin_basename(__FILE__);
	$page_uri = $_SERVER['PHP_SELF'] . "?page=" . basename(__FILE__);

	// Post count option
	{
		print "<form name='ChangeLinkPreference' method='post' action='" .
			$page_uri . "&action=toggle_count_inside_link'>\n";

		print '<p><input type="checkbox" name="Category_Order_Put_Post_Count_Inside_Link"';

		if (get_option('Category_Order_Put_Post_Count_Inside_Link'))
			print " checked";

		print " onClick='ChangeLinkPreference.submit()'> Put the count of the number of posts in the category (if present)
			inside the link, making it clickable.</p>\n";

		print "</form>\n";
	}

	// Folding option
	{
		$enable_category_folding =
			get_option('Category_Order_Enable_Category_Folding');

		print "<form name='ChangeFoldingPreference' method='post' action='" .
			$page_uri . "&action=toggle_category_folding'>\n";

		print '<p><input type="checkbox" name="Category_Order_Enable_Category_Folding"';

		if ($enable_category_folding)
			print " checked";

		print " onClick='ChangeFoldingPreference.submit()'> \"Fold\" indented
			categories until the unindented category above is clicked. Folded
			categories have a \"+\" next to them indicating that they can be
			expanded by clicking on the category. Note that this folding is
			based entirely on the indentation above and not any parent-child
			relationship of the categories.</p>\n";

		print "</form>\n";

		// Sum post count option
		{
			print "<div style='padding-left:2em;";

			if (!$enable_category_folding)
				print "color:gray;";
				
			print "'>\n";

			print "<form name='ChangeSumPostCountsPreference' method='post' action='" .
				$page_uri . "&action=toggle_sum_post_counts'>\n";

			print '<p><input type="checkbox" name="Category_Order_Sum_Post_Counts"';

			if (get_option('Category_Order_Sum_Post_Counts'))
				print " checked";

			if (!$enable_category_folding)
				print " disabled";

			print " onClick='ChangeSumPostCountsPreference.submit()'>
			  Update the post count of folded categories to include the post
				counts of hidden categories.</p>\n";

			print "</form>\n</div>\n";
		}
	}

	// Delete options
// FOR TESTING
/*
print "<form name='DeleteOptions' method='post' action='" .
$page_uri . "&action=delete_options'>";
print "<p class='submit'>";
print "<input type='submit' name='Submit' " .
"value='Delete Options for Plugin'></p></form>";
*/

	print "</div>\n";
}

// --------------------------------------------------------------------

// Manipulates the plugin options according to the actions of the user in the
// management page. Returns the (possibly updated) category order
function handle_action() {
	GLOBAL $_POST, $_GET;

	// Stolen from users.php. Sets the values of the specified variables from
	// the GET or POST object values
	$vars_to_import = array('action','parent','index');
	for ($i=0; $i<count($vars_to_import); $i += 1) {
		$wpvar = $vars_to_import[$i];
		if (!isset($$wpvar)) {
			if (empty($_POST["$wpvar"])) {
				if (empty($_GET["$wpvar"])) {
					$$wpvar = '';
				} else {
					$$wpvar = $_GET["$wpvar"];
				}
			} else {
				$$wpvar = $_POST["$wpvar"];
			}
		}
	}
	$index = (int) $index;

// FOR TESTING
//print "BEFORE:<br>";
//category_order::print_html_data(category_order_shared::get_category_order());

	if ($action == '')
		return;


	else if ($action == 'toggle_count_inside_link')
	{
		if (get_option('Category_Order_Put_Post_Count_Inside_Link'))
			update_option('Category_Order_Put_Post_Count_Inside_Link', 0);
		else
			update_option('Category_Order_Put_Post_Count_Inside_Link', 1);
	}


	else if ($action == 'toggle_category_folding')
	{
		if (get_option('Category_Order_Enable_Category_Folding'))
			update_option('Category_Order_Enable_Category_Folding', 0);
		else
			update_option('Category_Order_Enable_Category_Folding', 1);
	}


	else if ($action == 'toggle_sum_post_counts')
	{
		if (get_option('Category_Order_Sum_Post_Counts'))
			update_option('Category_Order_Sum_Post_Counts', 0);
		else
			update_option('Category_Order_Sum_Post_Counts', 1);
	}

	else if ($action == 'insert_space_before') {
		$category_order = category_order_shared::get_category_order();
		array_splice($category_order,$index,0,0);
		$category_order[$index] = array('',0);
		update_option('Category_Order', var_export($category_order,1));
	}
	else if ($action == 'insert_space_after') {
		$category_order = category_order_shared::get_category_order();
		array_splice($category_order,$index+1,0,0);
		$category_order[$index+1] = array('',0);
		update_option('Category_Order', var_export($category_order,1));
	}
	else if ($action == 'delete_spacer') {
		$category_order = category_order_shared::get_category_order();
		array_splice($category_order,$index,1);
		update_option('Category_Order', var_export($category_order,1));
	}
	

	else if ($action == 'reset') {
		$category_order = category_order_shared::get_category_order(true);
		update_option('Category_Order', var_export($category_order,1));
	}


	else if ($action == 'moveup') {
		$category_order = category_order_shared::get_category_order();
		$temp = $category_order[$index-1];
		$category_order[$index-1] = $category_order[$index];
		$category_order[$index] = $temp;
		update_option('Category_Order', var_export($category_order,1));
	}
	else if ($action == 'movedown') {
		$category_order = category_order_shared::get_category_order();
		$temp = $category_order[$index+1];
		$category_order[$index+1] = $category_order[$index];
		$category_order[$index] = $temp;
		update_option('Category_Order', var_export($category_order,1));
	}
	else if ($action == 'indent') {
		$category_order = category_order_shared::get_category_order();
		$category_order[$index][1]++;
		update_option('Category_Order', var_export($category_order,1));
	}
	else if ($action == 'outdent') {
		$category_order = category_order_shared::get_category_order();
		$category_order[$index][1]--;
		update_option('Category_Order', var_export($category_order,1));
	}


	else if ($action == 'delete_options') {
		delete_option('Category_Order');
		delete_option('Category_Order_Put_Post_Count_Inside_Link');
	}


// FOR TESTING
//print "AFTER:<br>";
//category_order::print_html_data(category_order_shared::get_category_order());

	return $category_order;
}

// --------------------------------------------------------------------

// Prints a table simulating the layout, along with controls for changing it
function print_category_table() {
	// Causes a class redefined error
	//$page_uri = $_SERVER['PHP_SELF'] . "?page=" . plugin_basename(__FILE__);
	$page_uri = $_SERVER['PHP_SELF'] . "?page=" . basename(__FILE__);

  $site_root = parse_url(get_settings('siteurl'));
  $site_root = trailingslashit($site_root['path']);
  $plugin_url = $site_root . 'wp-content/plugins/category-order';

	$category_order = category_order_shared::get_category_order();

	print "<table cellpadding=\"3\" cellspacing=\"3\">\n";

	for ($i = 0; $i < count($category_order); $i++) {
		$category_id = $category_order[$i][0];
		$indent = $category_order[$i][1];

		// Name of category (or -- Spacer --)
		print "<tr>\n<td>";

		for ($j=0; $j < $indent; $j++)
			print "&nbsp;&nbsp;&nbsp;&nbsp;";

		if ($category_id == '')
			print "<em>[Spacer]</em>";
		else
		{
			$category = get_category($category_id);
			print $category->cat_name . "</td>";
		}

		print "</td>\n";


		// Up
		if ($i == 0)
			print "<td>".
				"<img src=\"$plugin_url/move_up_inactive_20x20.gif\">".
				"</td>\n";
		else
			print "<td><a href=\"" . $page_uri . "&action=moveup&index=$i\">" .
				"<img src=\"$plugin_url/move_up_active_20x20.gif\">".
				"</a></td>\n";


		// Down
		if ($i == count($category_order)-1)
			print "<td>".
				"<img src=\"$plugin_url/move_down_inactive_20x20.gif\">".
				"</td>\n";
		else
			print "<td><a href=\"" . $page_uri . "&action=movedown&index=$i\">".
				"<img src=\"$plugin_url/move_down_active_20x20.gif\">".
				"</a></td>\n";


		// Outdent
		if ( $indent == 0 || $category_id == '')
			print "<td>".
				"<img src=\"$plugin_url/move_left_inactive_20x20.gif\">".
				"</td>\n";
		else
			print "<td><a href=\"" . $page_uri . "&action=outdent&index=$i\">".
				"<img src=\"$plugin_url/move_left_active_20x20.gif\">".
				"</a></td>\n";


		// Indent
		if ( $category_id == '' )
			print "<td>".
				"<img src=\"$plugin_url/move_right_inactive_20x20.gif\">".
				"</td>\n";
		else
			print "<td><a href=\"" . $page_uri . "&action=indent&index=$i\">".
				"<img src=\"$plugin_url/move_right_active_20x20.gif\">".
				"</a></td>\n";


		// Add or delete spacer
		if ($category_id == '') {
			print "<td colspan=2 align=center><a href=\"" . $page_uri . "&action=delete_spacer&index=$i\">".
				"Delete this spacer</a></td>\n";
		}
		else
		{
			print "<td><a href=\"" . $page_uri . "&action=insert_space_before&index=$i\">".
				"Insert spacer before this item</a></td>\n";

			print "<td><a href=\"" . $page_uri . "&action=insert_space_after&index=$i\">".
				"Insert spacer after this item</a></td>\n";
		}

		print "</tr>\n";
	}

	print "</table>\n";
}

}

add_action('admin_menu',
	array('category_order_management','setup_category_order_management_page'));

?>
