#define STRICT // To get it to like my callback function.
#include <windows.h> // For Process related stuff
#include <tchar.h> // for _T and _strspnp

/*
This function gets the argument following the given flag in the given command line.
Arguments containing spaces should be quoted. (The quotes will be detected and
removed. For example: /b blah /s "some stuff" would return blah as the argument for
b, and "some stuff" (without quotes) as the argument for s.
*/
void GetFlagArgument(char* commandLine, LPSTR flag, LPSTR returnArgument)
{
	// Find the flag
	char searchFlag[256];
	strcpy(searchFlag,"/");
	strcat(searchFlag,flag);
	strcat(searchFlag," ");

	char* commandLocation;
	commandLocation = strstr(commandLine, searchFlag);

	if (commandLocation == NULL)
	{
		returnArgument[0] = '\0';
		return;
	}

	commandLocation += strlen(searchFlag);

	char* beginCommand;

	// The beginning is the first non-space character.
	beginCommand = _strspnp(commandLocation," ");

	if (beginCommand == NULL)
	{
		returnArgument[0] = '\0';
		return;
	}

	char* endCommand;

	// Handle quotes around the argument
	if (beginCommand[0] == '\"')
	{
		beginCommand++;
		endCommand = beginCommand;

		bool foundEndQuote(false);
		while (endCommand != NULL && !foundEndQuote)
		{
			endCommand = strchr(endCommand,'\"');
			if ((endCommand-1)[0] != '\\')
			{
				foundEndQuote = true;
			}
		}

		endCommand--;
	}
	else
	// Argument isn't quoted
	{
		endCommand = strchr(beginCommand,' ');
		if (endCommand == NULL)
		{
			endCommand = beginCommand+strlen(beginCommand);
		}

		endCommand--;
	}

	int commandLength = endCommand-beginCommand+1;

	strncpy(returnArgument,beginCommand,commandLength);
	returnArgument[commandLength] = '\0';
}

static BOOL CALLBACK CloseProgramCallback(HWND hwndProgramToClose, LPARAM partialName)
{
	/*	
	Another way that doesn't rely on the window's name is to use Spy to
	find out the window's class name. (Then use it in the first argument.)
	*/
	// Oops! Didn't find window
	if ((::GetWindow(hwndProgramToClose, GW_OWNER) == NULL) &&
		(::IsWindowVisible(hwndProgramToClose)))
	{
		char windowName[256];
		GetWindowText(hwndProgramToClose,windowName, 255);

		if (strstr(windowName,(char *)partialName))
		{
				
			// Nicely ask the program to close itself.
			::PostMessage(hwndProgramToClose,WM_CLOSE,(WPARAM)0,(LPARAM)0);

			// Give it 1 second to comply.
			Sleep(1000);

			DWORD exitStatus;
			GetExitCodeProcess(hwndProgramToClose,&exitStatus);

			// If the nice way didn't work, do it the mean way.
			if (exitStatus == STILL_ACTIVE)
			{
				UINT exitCode;
				TerminateProcess(hwndProgramToClose,exitCode);
			}
		}
	}
	return (TRUE);
}

/*
Return value is 1 if the window couldn't be closed.
*/
void CloseProgram(char *partialName)
{
	::EnumWindows(CloseProgramCallback, (LPARAM)partialName);
}

/*
Note! You can use CreateToolhelp32Snapshot, Process32First, and
Process32Last to get a snapshot of the running processes, threads,
memory usage, etc. (In Win NT, it would have to be EnumProcesses.)

Use GetWindowThreadProcessId() with the former to get a handle to the
window you want to close.

*/

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpszCmndLine,int cmdShow)
{

	char partialName[256];

	// Get the command off of the lpszCmndLine
	GetFlagArgument(lpszCmndLine,"p",partialName);

	// Exit if no command was given.
	if (strcmp(partialName,"") == 0)
	{
		return(-1);
	}

	int returnValue;
	CloseProgram(partialName);
	return (returnValue);

}
