#include "RunQuiet.h"
#include <windows.h> // For Process related stuff

char directory[MAX_PATH];
char command[MAX_PATH];
bool waitForCompletion;

RunQuiet::RunQuiet()
{
}

RunQuiet::~RunQuiet()
{
}


void RunQuiet::SetDirectory(const char* inDirectory)
{
	strcpy(directory,inDirectory);
}

void RunQuiet::SetCommand(const char* inCommand)
{
	strcpy(command,inCommand);
}

void RunQuiet::SetWaitForCompletion(const bool value)
{
	waitForCompletion = value;
}

void RunQuiet::SetStyle(SHORT inStyleFlag)
{
	styleFlag = inStyleFlag;
}

int RunQuiet::Execute()
{
	int returnValue;

	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	// We want its console window to be invisible to the user.
	si.dwFlags = STARTF_USESHOWWINDOW;
	si.wShowWindow = styleFlag;
	
	returnValue = CreateProcess(NULL, _T(command), NULL, NULL, FALSE,
		CREATE_SUSPENDED | IDLE_PRIORITY_CLASS, NULL, _T(directory), &si, &pi);

	// If it started okay...
	if (returnValue != 0)
	{
		ResumeThread(pi.hThread);

		if (waitForCompletion)
		{
			WaitForSingleObject( pi.hProcess, INFINITE );
		}

		CloseHandle(pi.hProcess);
		CloseHandle(pi.hThread);
	}


	return(returnValue);
}
