#include <windows.h> // For Process related stuff
#include <tchar.h> // for _T and _strspnp
#include "RunQuiet.h"

/*
This function gets the argument following the given flag in the given command line.
Arguments containing spaces should be quoted. (The quotes will be detected and
removed. For example: /b blah /s "some stuff" would return blah as the argument for
b, and "some stuff" (without quotes) as the argument for s.
*/
void GetFlagArgument(char* commandLine, LPSTR flag, LPSTR returnArgument)
{
	// Find the flag
	char searchFlag[256];
	strcpy(searchFlag,"/");
	strcat(searchFlag,flag);
	strcat(searchFlag," ");

	char* commandLocation;
	commandLocation = strstr(commandLine, searchFlag);

	if (commandLocation == NULL)
	{
		returnArgument[0] = '\0';
		return;
	}

	commandLocation += strlen(searchFlag);

	char* beginCommand;

	// The beginning is the first non-space character.
	beginCommand = _strspnp(commandLocation," ");

	if (beginCommand == NULL)
	{
		returnArgument[0] = '\0';
		return;
	}

	char* endCommand;

	// Handle quotes around the argument
	if (beginCommand[0] == '\"')
	{
		beginCommand++;
		endCommand = beginCommand;

		bool foundEndQuote(false);
		while (endCommand != NULL && !foundEndQuote)
		{
			endCommand = strchr(endCommand,'\"');
			if ((endCommand-1)[0] != '\\')
			{
				foundEndQuote = true;
			}
		}

		endCommand--;
	}
	else
	// Argument isn't quoted
	{
		endCommand = strchr(beginCommand,' ');
		if (endCommand == NULL)
		{
			endCommand = beginCommand+strlen(beginCommand);
		}

		endCommand--;
	}

	int commandLength = endCommand-beginCommand+1;

	strncpy(returnArgument,beginCommand,commandLength);
	returnArgument[commandLength] = '\0';
}

int WINAPI WinMain(HANDLE hInst, HANDLE hPrevInst, LPSTR lpszCmndLine,int cmdShow)
{

	// Get the command off of the lpszCmndLine
	char command[MAX_PATH];
	GetFlagArgument(lpszCmndLine,"c",command);

	// Exit if no command was given.
	if (strcmp(command,"") == 0)
	{
		return(-1);
	}

	// Now chop off the command so that its flags won't interfere with our flags
	lpszCmndLine[strstr(lpszCmndLine,"/c ")-lpszCmndLine] = '\0';

	// Get the working directory
	char directory[MAX_PATH];
	GetFlagArgument(lpszCmndLine,"d",directory);

	// Use the current directory if nothing is specified.
	if (strcmp(directory,"") == 0)
	{
		GetCurrentDirectory(MAX_PATH,directory);
	}


	// See what style they want.
	char style[256];
	SHORT styleFlag;
	GetFlagArgument(lpszCmndLine,"m",style);

	if (strcmp(style,"max") == 0)
	{
		styleFlag = SW_SHOWMAXIMIZED;
	}
	else if (strcmp(style,"min") == 0)
	{
		styleFlag = SW_SHOWMINIMIZED;
	}
	else if (strcmp(style,"hide") == 0)
	{
		styleFlag = SW_HIDE;
	}
	else
	{
		styleFlag = SW_HIDE;
	}

	// See if they want us to wait for the process to exit
	bool waitForExit(false);
	if (strstr(lpszCmndLine,"/w ") != NULL)
	{
		waitForExit = true;
	}

	RunQuiet aRunQuiet;
	aRunQuiet.SetDirectory(directory);
	aRunQuiet.SetCommand(command);
	aRunQuiet.SetWaitForCompletion(waitForExit);
	aRunQuiet.SetStyle(styleFlag);
	aRunQuiet.Execute();

	return (0);

}
